#adjust this to the folder that contains data files
setwd("/Users/ding/Documents/R/Main")

# transfer all the output to a file.
sink("output_mainstudy_dataPreparationI", split = "TRUE")
R.version.string
sessionInfo()
# for more information, use R.Version()

cat("\n###############################################################################\n")
cat("\n# Data preparation I for the paper for International Journal of Human-Computer Studies: Virtual reality negotiation training system with exposure to simulated thoughts and conversations: Design and evaluation\n")
cat("\n# 2018 TUDelft\n")
cat("\n# Output file: output_mainstudy_dataPreparationI.txt will be created \n")
cat("\n# Author: Ding Ding \n")
cat("\n# required datafile\n")
cat("\n# - Pre-measurement.csv\n")
cat("\n# - Intermediate+measurement_I.csv\n")
cat("\n# - Intermediate+measurement_II.csv\n")
cat("\n# - Post-measurement_Waitinglist.csv\n")
cat("\n# - Post-measurement.csv\n")
cat("\n# - FollowUp.csv\n")
cat("\n# - Self-esteem.csv\n")
cat("\n###############################################################################\n")

################################# libraries #################################
library (foreign)
library (car)
library (ggplot2)
library (nlme)
library (reshape)
library (lattice)
library (MASS)
library(psych)
library(pwr)
library(ggpubr)
library(dplyr)
library(lsr)
library(outliers)
library(coin)
library(lme4)

################################# Data preparation ###########################

################################# Data of Pre-measurement for all participants
# File with pre measurement data from all participants in wide format
# Data orignally obtained from Pre-measurement.csv 
#
# data fields
#
#1 ID_MainPre: ID number of all the paticipants
#2 SE: self-efficacy of all the paticipants
#3 Gender: gender of all the paticipants
#4 Age: age of all the paticipants
#5 VRexperience: the VR experience the participants have: Yes/Maybe/No
#6 NegoFrequenceType1_Pre
#7 NegoFrequenceType2_Pre
#8 NegoFrequenceType3_Pre
#9 NegoFrequenceType4_Pre
#10 Negotiationsuccess_Pre
#11 Negotiationwinwin_Pre
#12 Satisfaction_outcome_Pre
#13 Satisfaction_process_Pre
#14 Satisfaction_performance_Pre
#15 Satisfaction_relationship_Pre

Pre<- read.csv("Pre-measurement.csv", header = TRUE)
ID_MainPre <- Pre[3:50,18]
SE <-Pre[3:50,38]
Gender <- Pre[3:50,19]
Age <- Pre[3:50,20]
VRexperience <- Pre[3:50,26]
NegoFrequenceType1_Pre <- Pre[3:50,112]
NegoFrequenceType2_Pre <- Pre[3:50,113]
NegoFrequenceType3_Pre <- Pre[3:50,114]
NegoFrequenceType4_Pre <- Pre[3:50,116]
Negotiationsuccess_Pre <- Pre[3:50,117]
NegotiationSuccess_Pre <- as.numeric(sub("%", "", Negotiationsuccess_Pre))/100
Negotiationwinwin_Pre <- Pre[3:50,118]
NegotiationWinwin_Pre <- as.numeric(sub("%", "", Negotiationwinwin_Pre))/100
Satisfaction_outcome_Pre<-Pre[3:50,119]
Satisfaction_process_Pre<-Pre[3:50,120]
Satisfaction_performance_Pre<-Pre[3:50,121]
Satisfaction_relationship_Pre<-Pre[3:50,122]

DemographicData<- data.frame(ID_MainPre,Gender,Age,VRexperience)
DemographicData$Age <- as.numeric(as.character(DemographicData$Age))
write.csv(DemographicData,"DemographicData.csv",row.names=FALSE)

SelfEfficacy_Pre <- data.frame(ID_MainPre,SE)
SelfEfficacy_Pre$ID_MainPre <- as.numeric(as.character(SelfEfficacy_Pre$ID_MainPre))
write.csv(SelfEfficacy_Pre,"SE_Pre measurement.csv",row.names=FALSE)

NegotiationBehaviour_Pre<-data.frame(ID_MainPre,Satisfaction_outcome_Pre,Satisfaction_process_Pre,Satisfaction_performance_Pre,Satisfaction_relationship_Pre,NegoFrequenceType1_Pre,NegoFrequenceType2_Pre,NegoFrequenceType3_Pre,NegoFrequenceType4_Pre,NegotiationSuccess_Pre,NegotiationWinwin_Pre)
NegotiationBehaviour_Pre$ID_MainPre<- as.numeric(as.character(NegotiationBehaviour_Pre$ID_MainPre))
NegotiationBehaviour_Pre$Satisfaction_outcome_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$Satisfaction_outcome_Pre))
NegotiationBehaviour_Pre$Satisfaction_process_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$Satisfaction_process_Pre))
NegotiationBehaviour_Pre$Satisfaction_performance_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$Satisfaction_performance_Pre))
NegotiationBehaviour_Pre$Satisfaction_relationship_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$Satisfaction_relationship_Pre))
NegotiationBehaviour_Pre$NegoFrequenceType1_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$NegoFrequenceType1_Pre))
NegotiationBehaviour_Pre$NegoFrequenceType2_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$NegoFrequenceType2_Pre))
NegotiationBehaviour_Pre$NegoFrequenceType3_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$NegoFrequenceType3_Pre))
NegotiationBehaviour_Pre$NegoFrequenceType4_Pre<- as.numeric(as.character(NegotiationBehaviour_Pre$NegoFrequenceType4_Pre))
write.csv(NegotiationBehaviour_Pre,"NegotiationBehaviour_Pre.csv",row.names=FALSE)

Pre_NegoKnowledge<-read.csv("Pre_Negotiation knowledge.csv", header = TRUE)
ID_Pre<-Pre_NegoKnowledge$ID
Pre_NegoKnowledge$sum<-rowSums(Pre_NegoKnowledge[2:9])
NegotiationKnowledge_Pre<-data.frame(ID_Pre,Pre_NegoKnowledge$sum)
colnames(NegotiationKnowledge_Pre) <- c("ID","Score")
NegotiationKnowledge_Pre$ID<-as.numeric(as.character(NegotiationKnowledge_Pre$ID))
NegotiationKnowledge_Pre$Score<-as.numeric(as.character(NegotiationKnowledge_Pre$Score))
write.csv(NegotiationKnowledge_Pre,"NegotiationKnowledge_Pre.csv",row.names=FALSE)

################################# Data of Post-measurement for Waitinglist group
# File with post measurement data from waitinglist group in wide format
# Data orignally obtained from Post-measurement_Waitinglist.csv 
#
# data fields
#
#1 ID_MainPost: participant ID number
#2 SE: self-efficacy
#3 PostWLSub: the self-efficacy data of the post-measurement for the Waitinglist group 

PostWL<- read.csv("Post-measurement_Waitinglist.csv", header = TRUE)
ID_MainPostWL <- PostWL[3:26,18]

#Self efficacy
SE <- PostWL[3:26,20]
SelfEfficacy_PostWL<- data.frame(ID_MainPostWL,SE)
SelfEfficacy_PostWL$ID_MainPostWL<- as.numeric(as.character(SelfEfficacy_PostWL$ID_MainPostWL))
write.csv(SelfEfficacy_PostWL,"Post_waitinglist.csv",row.names=FALSE)

#Negotiation behaviour
NegoFrequenceType1_PostWL <- PostWL[3:26,94]
NegoFrequenceType2_PostWL <- PostWL[3:26,95]
NegoFrequenceType3_PostWL <- PostWL[3:26,96]
NegoFrequenceType4_PostWL <- PostWL[3:26,98]

Negosuccess_PostWL <- PostWL[3:26,99]
NegoSuccess_PostWL <- as.numeric(sub("%", "", Negosuccess_PostWL))/100
Negotiationwinwin_PostWL <- PostWL[3:26,100]
NegotiationWinwin_PostWL <- as.numeric(sub("%", "", Negotiationwinwin_PostWL))/100

Satisfaction_outcome_PostWL<-PostWL[3:26,101]
Satisfaction_process_PostWL<-PostWL[3:26,102]
Satisfaction_performance_PostWL<-PostWL[3:26,103]
Satisfaction_relationship_PostWL<-PostWL[3:26,104]

NegotiationBehaviour_PostWL<-data.frame(ID_MainPostWL,Satisfaction_outcome_PostWL,Satisfaction_process_PostWL,Satisfaction_performance_PostWL,Satisfaction_relationship_PostWL,NegoFrequenceType1_PostWL,NegoFrequenceType2_PostWL,NegoFrequenceType3_PostWL,NegoFrequenceType4_PostWL,NegoSuccess_PostWL,NegotiationWinwin_PostWL)
NegotiationBehaviour_PostWL$ID_MainPostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$ID_MainPostWL))
NegotiationBehaviour_PostWL$Satisfaction_outcome_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$Satisfaction_outcome_PostWL))
NegotiationBehaviour_PostWL$Satisfaction_process_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$Satisfaction_process_PostWL))
NegotiationBehaviour_PostWL$Satisfaction_performance_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$Satisfaction_performance_PostWL))
NegotiationBehaviour_PostWL$Satisfaction_relationship_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$Satisfaction_relationship_PostWL))

NegotiationBehaviour_PostWL$NegoFrequenceType1_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$NegoFrequenceType1_PostWL))
NegotiationBehaviour_PostWL$NegoFrequenceType2_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$NegoFrequenceType2_PostWL))
NegotiationBehaviour_PostWL$NegoFrequenceType3_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$NegoFrequenceType3_PostWL))
NegotiationBehaviour_PostWL$NegoFrequenceType4_PostWL<- as.numeric(as.character(NegotiationBehaviour_PostWL$NegoFrequenceType4_PostWL))
write.csv(NegotiationBehaviour_PostWL,"NegotiationBehaviour_PostWL.csv",row.names=FALSE)

#Negotiation Knowledge
PostWL_NegoKnowledge<-read.csv("Post_WaitingList_Negotiation Knowledge.csv", header = TRUE)
ID_PostWL<-PostWL_NegoKnowledge$ID
PostWL_NegoKnowledge$sum<-rowSums(PostWL_NegoKnowledge[2:9])
NegotiationKnowledge_PostWL<-data.frame(ID_PostWL,PostWL_NegoKnowledge$sum)
colnames(NegotiationKnowledge_PostWL) <- c("ID","Score")
NegotiationKnowledge_PostWL$ID<-as.numeric(as.character(NegotiationKnowledge_PostWL$ID))
NegotiationKnowledge_PostWL$Score<-as.numeric(as.character(NegotiationKnowledge_PostWL$Score))
write.csv(NegotiationKnowledge_PostWL,"NegotiationKnowledge_PostWL.csv",row.names=FALSE)

################################# Data of the first intermediate measurement  
# File with the first intermediate measurement data from all participates in wide format
# Data orignally obtained from Intermediate+measurement_I.csv 
#
# data fields
#
#1 ID_MainInterI: participant ID number
#2 SE: self-efficacy
#3 InterINEW: the self-efficacy data of the first intermediate measurement 

InterI <- read.csv("Intermediate+measurement_I.csv", header = TRUE)
ID_MainInterI <- InterI[3:50,18]
SE1 <-InterI[3:50,19]
SelfEfficacy_InterI<- data.frame(ID_MainInterI,SE1)
SelfEfficacy_InterI$ID_MainInterI<- as.numeric(as.character(SelfEfficacy_InterI$ID_MainInterI))
#InterINEW <- InterISub[order(InterISub$ID),]
write.csv(SelfEfficacy_InterI,"SE_intermediate measurement I.csv",row.names=FALSE)

################################# Data of the second intermediate measurement  
# File with the second intermediate measurement data from all participates in wide format
# Data orignally obtained from Intermediate+measurement_II.csv 
#
# data fields
#
#1 ID_InterII: participant ID number
#2 SE2: self-efficacy data after the second training session
#3 SelfEfficacy_InterII: the self-efficacy data of the second intermediate measurement 

InterII <- read.csv("Intermediate+measurement_II.csv", header = TRUE)
ID_InterII <- InterII[3:50,18]
SE2 <-InterII[3:50,19]
SelfEfficacy_InterII<- data.frame(ID_InterII,SE2)
SelfEfficacy_InterII$ID_InterII<- as.numeric(as.character(SelfEfficacy_InterII$ID_InterII))
#InterIINEW <- InterIISub[order(InterIISub$ID),]
write.csv(SelfEfficacy_InterII,"SE_intermediate measurement II.csv",row.names=FALSE)

################################# Data of Post-measurement for all participants
# File with the post measurement data from all participants in wide format
# Data orignally obtained from Post-measurement.csv 
#
# data fields
#
#1 ID: participant ID number
#2 SE: self-efficacy
#3 PostNEW: the self-efficacy data of the post-measurement for all participants
#3 PostEX: the self-efficacy data of the post-measurement for the participants who join the experiment

Post <- read.csv("Post-measurement.csv", header = TRUE)
ID_MainPost <- Post[3:50,18]
SE3 <-Post[3:50,20]

NegoFrequenceType1_Post <- Post[3:50,94]
NegoFrequenceType2_Post <- Post[3:50,95]
NegoFrequenceType3_Post <- Post[3:50,96]
NegoFrequenceType4_Post <- Post[3:50,98]

Negosuccess_Post <- Post[3:50,99]
NegoSuccess_Post <- as.numeric(sub("%", "", Negosuccess_Post))/100
Negotiationwinwin_Post <- Post[3:50,100]
NegotiationWinwin_Post <- as.numeric(sub("%", "", Negotiationwinwin_Post))/100

Satisfaction_outcome_Post<-Post[3:50,101]
Satisfaction_process_Post<-Post[3:50,102]
Satisfaction_performance_Post<-Post[3:50,103]
Satisfaction_relationship_Post<-Post[3:50,104]

Utility <- Post[3:50,105:111]

#Self-efficacy
SelfEfficacy_Post<- data.frame(ID_MainPost,SE3)
SelfEfficacy_Post$ID_MainPost<- as.numeric(as.character(SelfEfficacy_Post$ID_MainPost))
write.csv(SelfEfficacy_Post,"SE_post measurement.csv",row.names=FALSE)

#Negotiation Behaviour and performacne
NegotiationBehaviour_Post<-data.frame(ID_MainPost,Satisfaction_outcome_Post,Satisfaction_process_Post,Satisfaction_performance_Post,Satisfaction_relationship_Post,NegoFrequenceType1_Post,NegoFrequenceType2_Post,NegoFrequenceType3_Post,NegoFrequenceType4_Post,NegoSuccess_Post,NegotiationWinwin_Post)
NegotiationBehaviour_Post$ID_MainPost<- as.numeric(as.character(NegotiationBehaviour_Post$ID_MainPost))
NegotiationBehaviour_Post$Satisfaction_outcome_Post<- as.numeric(as.character(NegotiationBehaviour_Post$Satisfaction_outcome_Post))
NegotiationBehaviour_Post$Satisfaction_process_Post<- as.numeric(as.character(NegotiationBehaviour_Post$Satisfaction_process_Post))
NegotiationBehaviour_Post$Satisfaction_performance_Post<- as.numeric(as.character(NegotiationBehaviour_Post$Satisfaction_performance_Post))
NegotiationBehaviour_Post$Satisfaction_relationship_Post<- as.numeric(as.character(NegotiationBehaviour_Post$Satisfaction_relationship_Post))

NegotiationBehaviour_Post$NegoFrequenceType1_Post<- as.numeric(as.character(NegotiationBehaviour_Post$NegoFrequenceType1_Post))
NegotiationBehaviour_Post$NegoFrequenceType2_Post<- as.numeric(as.character(NegotiationBehaviour_Post$NegoFrequenceType2_Post))
NegotiationBehaviour_Post$NegoFrequenceType3_Post<- as.numeric(as.character(NegotiationBehaviour_Post$NegoFrequenceType3_Post))
NegotiationBehaviour_Post$NegoFrequenceType4_Post<- as.numeric(as.character(NegotiationBehaviour_Post$NegoFrequenceType4_Post))
write.csv(NegotiationBehaviour_Post,"NegotiationBehaviour_Post.csv",row.names=FALSE)

#Negotiation knowledge
Post_NegoKnowledge<-read.csv("Post_Negotiation knowledge.csv", header = TRUE)
ID_Post<-Post_NegoKnowledge$ID
Post_NegoKnowledge$sum<-rowSums(Post_NegoKnowledge[2:9])
NegotiationKnowledge_Post<-data.frame(ID_Post,Post_NegoKnowledge$sum)
colnames(NegotiationKnowledge_Post) <- c("ID","Score")
NegotiationKnowledge_Post$ID<-as.numeric(as.character(NegotiationKnowledge_Post$ID))
NegotiationKnowledge_Post$Score<-as.numeric(as.character(NegotiationKnowledge_Post$Score))
write.csv(NegotiationKnowledge_Post,"NegotiationKnowledge_Post.csv",row.names=FALSE)

#Utility
Utility_Post<- data.frame(ID_MainPost,Utility)
Utility_Post$ID_MainPost<- as.numeric(as.character(Utility_Post$ID_MainPost))
write.csv(Utility_Post,"Utility_post measurement.csv",row.names=FALSE)

################################# Data of Follow-up+measurement for all participants 
# File with the follow-up measurement data from all the participants in wide format
# Data orignally obtained from Follow-up+measurement.csv 
#
# data fields
#
#1 ID: participant ID number
#2 SE: self-efficacy
#3 PostWLSub: the self-efficacy data of the follow-up measurement

follow<- read.csv("Follow-up+measurement.csv", header = TRUE)
ID_MainFollow <- follow[3:49,14]
SE_follow <- follow[3:49,15]

#Self-efficacy
SelfEfficacy_follow<- data.frame(ID_MainFollow,SE_follow)
SelfEfficacy_follow$ID_MainFollow<- as.numeric(as.character(SelfEfficacy_follow$ID_MainFollow))
write.csv(SelfEfficacy_follow,"SE_Follow-up measurement.csv",row.names=FALSE)

# Negotiation behaviour
NegoFrequenceType1_follow <- follow[3:49,89]
NegoFrequenceType2_follow <- follow[3:49,90]
NegoFrequenceType3_follow <- follow[3:49,91]
NegoFrequenceType4_follow <- follow[3:49,93]

Negosuccess_follow <- follow[3:49,94]
NegoSuccess_follow <- as.numeric(sub("%", "", Negosuccess_follow))/100
Negotiationwinwin_follow <- follow[3:49,95]
NegotiationWinwin_follow <- as.numeric(sub("%", "", Negotiationwinwin_follow))/100

Satisfaction_outcome_follow<-follow[3:49,96]
Satisfaction_process_follow<-follow[3:49,97]
Satisfaction_performance_follow<-follow[3:49,98]
Satisfaction_relationship_follow<-follow[3:49,99]

NegotiationBehaviour_follow<-data.frame(ID_MainFollow,Satisfaction_outcome_follow,Satisfaction_process_follow,Satisfaction_performance_follow,Satisfaction_relationship_follow,NegoFrequenceType1_follow,NegoFrequenceType2_follow,NegoFrequenceType3_follow,NegoFrequenceType4_follow,NegoSuccess_follow,NegotiationWinwin_follow)

NegotiationBehaviour_follow$ID_MainFollow<- as.numeric(as.character(NegotiationBehaviour_follow$ID_MainFollow))
NegotiationBehaviour_follow$Satisfaction_outcome_follow<- as.numeric(as.character(NegotiationBehaviour_follow$Satisfaction_outcome_follow))
NegotiationBehaviour_follow$Satisfaction_process_follow<- as.numeric(as.character(NegotiationBehaviour_follow$Satisfaction_process_follow))
NegotiationBehaviour_follow$Satisfaction_performance_follow<- as.numeric(as.character(NegotiationBehaviour_follow$Satisfaction_performance_follow))
NegotiationBehaviour_follow$Satisfaction_relationship_follow<- as.numeric(as.character(NegotiationBehaviour_follow$Satisfaction_relationship_follow))

NegotiationBehaviour_follow$NegoFrequenceType1_follow<- as.numeric(as.character(NegotiationBehaviour_follow$NegoFrequenceType1_follow))
NegotiationBehaviour_follow$NegoFrequenceType2_follow<- as.numeric(as.character(NegotiationBehaviour_follow$NegoFrequenceType2_follow))
NegotiationBehaviour_follow$NegoFrequenceType3_follow<- as.numeric(as.character(NegotiationBehaviour_follow$NegoFrequenceType3_follow))
NegotiationBehaviour_follow$NegoFrequenceType4_follow<- as.numeric(as.character(NegotiationBehaviour_follow$NegoFrequenceType4_follow))

write.csv(NegotiationBehaviour_follow,"NegotiationBehaviour_follow.csv",row.names=FALSE)

#Negotiation knowledge
Follow_NegoKnowledge<-read.csv("Follow_Negotiation knowledge.csv", header = TRUE)
ID_Follow<-Follow_NegoKnowledge$ID
Follow_NegoKnowledge$sum<-rowSums(Follow_NegoKnowledge[2:9])
NegotiationKnowledge_Follow<-data.frame(ID_Follow,Follow_NegoKnowledge$sum)
colnames(NegotiationKnowledge_Follow) <- c("ID","Score")
NegotiationKnowledge_Follow$ID<-as.numeric(as.character(NegotiationKnowledge_Follow$ID))
NegotiationKnowledge_Follow$Score<-as.numeric(as.character(NegotiationKnowledge_Follow$Score))
write.csv(NegotiationKnowledge_Follow,"NegotiationKnowledge_Follow.csv",row.names=FALSE)

################################# Negotiation knowledge test
# File with all rating form two coders
# Data orignally obtained from the file: Sample data_Coder A.csv and Sample data_Coder B.csv
#
# data fields
TestID<- sample(1:167, 28, replace=F)

SampleNegoKnowledge_A <- read.csv("Sample data_Coder A.csv", header = TRUE)
SampleNegoKnowledge_B<- read.csv("Sample data_Coder B.csv", header = TRUE)
ID_Sample<-SampleNegoKnowledge_A$ID
SampleNegoKnowledge_A$sum<-rowSums(SampleNegoKnowledge_A[2:9])
SampleNegoKnowledge_B$sum<-rowSums(SampleNegoKnowledge_B[2:9])
SampleNegoKnowledge<-data.frame(ID_Sample,SampleNegoKnowledge_A$sum,SampleNegoKnowledge_B$sum)
colnames(SampleNegoKnowledge) <- c("ID","CoderA", "CoderB")
SampleNegoKnowledge$CoderA<-as.numeric(as.character(SampleNegoKnowledge$CoderA))
SampleNegoKnowledge$CoderB<-as.numeric(as.character(SampleNegoKnowledge$CoderB))
write.csv(SampleNegoKnowledge,"NegoKnowledge_CodingSamples.csv",row.names=FALSE)

######### stop redireting output.
sink()
cat("\nOutput of the analysis can be found back in file output_mainstudy_dataPreparationI.txt")
